/*------------------------------------------------------------------------------
<auto-generated>
    Este codigo fue generado por Pectra Forms

Cambios en este archivo pueden ocasionar un comportamiento incorrecto.
</auto-generated>
------------------------------------------------------------------------------*/
var appShellCache = '#REPLACE_FORM_CACHE_NAME#';
var dataCache = '#REPLACE_FORM_CACHE_NAME#';
var apiUrl = '';

var filesToCache = [
  'Default',
  'Activities',
  'Inbox',
  #REPLACE_FORM_VIEWS#
  'Content/font-awesome.min.css',
  'Content/bootstrap.min.css',
  'Content/mdb.min.css',
  'Content/style.css',
  'Content/toastr.min.css',
  'Content/jquery.mmenu.css',
  'Content/jquery.mmenu.positioning.css',
  'Scripts/app.js',
  'Scripts/jquery-3.2.1.min.js',
  'Scripts/popper.min.js',
  'Scripts/bootstrap.min.js',
  'Scripts/bootstrap.min.js.map',
  'Scripts/bootstrap-waitingfor.min.js',
  'Scripts/mdb.min.js',
  'Scripts/toastr.js.map',
  'Scripts/toastr.min.js',
  'Scripts/cryptojs.js',
  'Scripts/jquery.mmenu.js',
  'font/roboto/Roboto-Bold.woff2',
  'font/roboto/Roboto-Medium.woff2',
  'font/roboto/Roboto-Regular.woff2',
  'font/roboto/Roboto-Light.woff2',
  'fonts/fontawesome-webfont.woff2?v=4.7.0',
  'favicon.ico',
  'manifest.json'
];

self.addEventListener('install', function (e) {
    //forzamos la utilizacin de la nueva versin de SW sin tener que esperar que el usuario cierre el navegador y vuelva a abrirlo con self.skipWaiting();
    //ms info https://developers.google.com/web/fundamentals/primers/service-workers/lifecycle?hl=es#updates
    self.skipWaiting();

    console.log('[Service Worker] Install');
    e.waitUntil(
      caches.open(appShellCache).then(function (cache) {
          console.log('[Service Worker] Caching app shell');
          return cache.addAll(filesToCache);
      })
    );
});

self.addEventListener('activate', function (e) {
    console.log('[Service Worker] Activate');
    e.waitUntil(
      caches.keys().then(function (keyList) {
          return Promise.all(keyList.map(function (key) {
              if (key !== appShellCache && key !== dataCache) {
                  console.log('[Service Worker] Removing old cache', key);
                  return caches.delete(key);
              }
          }));
      })
    );
    /*
     * Fixes a corner case in which the app wasn't returning the latest data.
     * You can reproduce the corner case by commenting out the line below and
     * then doing the following steps: 1) load app for first time so that the
     * initial New York City data is shown 2) press the refresh button on the
     * app 3) go offline 4) reload the app. You expect to see the newer NYC
     * data, but you actually see the initial data. This happens because the
     * service worker is not yet activated. The code below essentially lets
     * you activate the service worker faster.
     */
    return self.clients.claim();
});

self.addEventListener('fetch', function (e) {
    //console.log('[Service Worker] Fetch', e.request.url);
    if (e.request.url.indexOf(apiUrl) > -1) {
        // verifica llamadas a la api solamente (no al shell)
        if (e.request.method == 'GET') {
            var methodGetTreeView = 'GetTreeView';
            var methodGetFunctionDef = 'GetFunctionDef';
            var methodGetOrgUoProf = 'GetOrgUoProf'
            var methodGetNewTrxId = 'GetNewTrxId';
            var methodGetInbox = 'GetInbox';
            var parameterTrxId = 'trxId='

            if (e.request.url.indexOf(methodGetTreeView) < 0 && e.request.url.indexOf(methodGetFunctionDef) < 0 && e.request.url.indexOf(methodGetOrgUoProf) < 0) {
                /*
                * Cuando la URL contiene apiUrl, la app intenta buscar datos "frescos" antes que nada en la red.
                * En caso Online se busca en la red y se guarda en cache la respuesta obtenida recientemente.
                * En caso Offline se busca en cache la ultima respuesta obtenida satisfactoriamente.
                * La logica esta basada en la estrategia offline "Network, falling back to cache" pero con personalizaciones.
                * https://jakearchibald.com/2014/offline-cookbook/#network-falling-back-to-cache
                */
                
                // en caso de "GetNewTrxId", "GetInbox" o query con "trxid=" el response NUNCA debe ser cacheado. Un TrxId nunca se puede repetir, incluso si se tratase de una misma actividad
                if (e.request.url.indexOf(methodGetNewTrxId) < 0 && e.request.url.indexOf(methodGetInbox) < 0 && e.request.url.toUpperCase().indexOf(parameterTrxId.toUpperCase()) < 0) {
                    e.respondWith(
                        caches.open(dataCache).then(function (cache) {
                            return fetch(e.request).then(function (response) {
                                /* obtuvo el dato desde la red */

                                // no debe almacenar en cache un response de token caducado (401) o errores (500)
                                if (response.status >= 200 && response.status < 300)
                                    cache.put(e.request, response.clone());

                                return response;
                            }).catch(function () {
                                // al obtener un fallo por motivos de red intenta buscar en cache, si no existe en cache retorna el estado "404 (not found)"
                                return cache.match(e.request).then(function (response) {
                                    return response || new Response('', { status: 404 });
                                });
                            });
                        })
                    );
                } else {
                    // en caso de "GetNewTrxId", "GetInbox" o query con "trxid=" se devuelve el response sin ser cacheado
                    e.respondWith(
                        fetch(e.request).then(function (response) {
                            return response;
                        }).catch(function (err) {
                            // informa sobre un fallo exclusivo de red (por ejemplo estado offline). En caso de errores ajenos a la red, por ejemplo un 500/400/404, no son capturados en este catch.
                            throw err;
                        })
                    );
                }
            } else {
                // En el caso de llamadas al servicio "GetTreeView", "GetFunctionDef" o "GetOrgUoProf", primero busca en cache y retorna el response si encuentra algo en cache.
                // Luego de retornar el response desde cache (o incluso en el caso de no haber encontrado nada en cache) hace en background una busqueda en red,
                // con el objetivo de obtener lo ultimo desde red y almacenarlo en cache para ser usado la proxima vez. Este enfoque sirve para datos que cambian poco en el tiempo
                e.respondWith(
                    caches.open(dataCache).then(function (cache) {
                        return cache.match(e.request).then(function (response) {
                            var fetchPromise = fetch(e.request).then(function (networkResponse) {
                                /* obtuvo el dato desde la red */

                                // no debe almacenar en cache un response de token caducado (401) o errores (500)
                                if (networkResponse.status >= 200 && networkResponse.status < 300)
                                    cache.put(e.request, networkResponse.clone());

                                return networkResponse;
                            });
                            return response || fetchPromise;
                        });
                    })
                );
            }
        } else {
            e.respondWith(
                fetch(e.request).catch(function (err) {
                    // informa sobre un fallo exclusivo de red (por ejemplo estado offline). En caso de errores ajenos a la red, por ejemplo un 500/400/404, no son capturados en este catch.
                    throw err;
                })
            );
        }
    } else {
        /*
        * The app is asking for app shell files. In this scenario the app uses the
        * "Cache, falling back to network" offline strategy:
        * https://jakearchibald.com/2014/offline-cookbook/#cache-falling-back-to-network
        */
        e.respondWith(
            caches.match(e.request).then(function (response) {
                return response || fetch(e.request);
            })
        );
    }
});

// clear the data cache
self.addEventListener('message', function (e) {
    if (e.data != null) {
        if (e.data == 'CLEARDATACACHE') {
            caches.delete(dataCache);
        }
        else if (e.data.apiUrl != null) {
            apiUrl = e.data.apiUrl;
        }
    }
})
